// Listing 4-2

import java.util.Scanner;

public class Listing4_2
{
   // Stałe globalne
   public final static int BASE_HOURS = 40;
   public final static double OT_MULTIPLIER = 1.5;
   
   public static void main(String[] args)
   {
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Deklarujemy zmienne lokalne
      double hoursWorked, payRate, grossPay;
      
      // Pobieramy liczbę przepracowanych godzin
      System.out.print("Wprowadź liczbę przepracowanych godzin.");
      hoursWorked = keyboard.nextInt();
      
      // Pobieramy stawkę godzinową
      System.out.print("Wprowadź stawkę godzinową.");
      payRate = keyboard.nextDouble();
      
      // Obliczamy wynagrodzenie
      if (hoursWorked > BASE_HOURS)
         grossPay = calcPayWithOT(hoursWorked, payRate);
      else
         grossPay = calcRegularPay(hoursWorked, payRate);
      
      // Wyświetlamy wynagrodzenie
      System.out.print("Wynagrodzenie wynosi " + grossPay + " zł.");
   }
   
   // Funkcja calcPayWithOT oblicza i zwraca
   // wynagrodzenie uwzględniając nadgodziny
   public static double calcPayWithOT(double hours, double rate)
   {
      // Zmienne lokalne
      double overtimeHours, overtimePay, gross;
      
      // Obliczamy liczbę nadgodzin
      overtimeHours = hours - BASE_HOURS;
      
      // Obliczamy wynagrodzenie za nadgodziny
      overtimePay = overtimeHours * rate * OT_MULTIPLIER;
      
      // Obliczamy całkowite wynagrodzenie
      gross = BASE_HOURS * rate + overtimePay;
      
      return gross;
   }

   // Funkcja calcRegularPay oblicza i zwraca
   // wynagrodzenie bez nadgodzin
   public static double calcRegularPay(double hours, double rate)
   {
      return hours * rate;
   }
}